<?php
error_reporting(0); ini_set('display_errors', 0); require_once __DIR__ . '/Config.php'; require_once SRC_PATH . '/classes/Database.php'; require_once SRC_PATH . '/classes/Game.php'; require_once SRC_PATH . '/controllers/MissionController.php'; require_once SRC_PATH . '/classes/LanguageController.php'; session_start(); $languageController = LanguageController::getInstance(); $missionController = new MissionController(); $activeMission = $missionController->getActiveMission(); if (!$activeMission && isset($_SESSION['active_mission_id'])) { $mission = $missionController->getMission($_SESSION['active_mission_id']); if ($mission && $mission->getStatus() == Mission::STATUS_IN_PROGRESS) { $mission->setActive(true); $mission->save($missionController->db); $activeMission = $mission; } } $isIframe = isset($_GET['iframe']) || (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] === 'iframe'); if (!$activeMission && !$isIframe) { header('Location: ' . BASE_URL . '/src/utils/Index.php'); exit; } if ($activeMission) { $missionId = $activeMission->getId(); if ($missionController->checkTimerExpired($missionId)) { $missionController->failMission($missionId); if (!$isIframe) { header('Location: ' . BASE_URL . '/index.php'); exit; } } } if ($isIframe && !$activeMission) { $currentIp = '192.168.1.100'; $currentDirectory = '/'; $traceLevel = 0; $timerStarted = false; $missionId = null; } else { $progress = $missionController->getMissionProgress($missionId); $currentIp = $progress['current_ip']; $currentDirectory = $progress['current_directory']; $traceLevel = $progress['trace_level']; $timerStarted = !empty($progress['timer_started_at']); $_SESSION['active_mission_id'] = $missionId; } ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $languageController->translate('vds.terminal_title'); ?></title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/public/css/style.css">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/public/css/vds.css">
    <script>
        window.BASE_URL = '<?php echo BASE_URL; ?>';
        window.ASSETS_URL = '<?php echo ASSETS_URL; ?>';
        window.PUBLIC_URL = '<?php echo PUBLIC_URL; ?>';
        window.API_URL = '<?php echo API_URL; ?>';
        window.LANGUAGES_URL = '<?php echo LANGUAGES_URL; ?>';
        window.CURRENT_MISSION_ID = <?php echo $activeMission ? $activeMission->getId() : 'null'; ?>;
    </script>
    <script src="<?php echo PUBLIC_URL; ?>/js/language.js"></script>
    <script src="<?php echo PUBLIC_URL; ?>/js/protection.js"></script>
    <style>
        :root {
            --terminal-bg: #0a0e14;
            --terminal-text: #c5c8c6;
            --accent-color: #01d758;
            --secondary-color: #00a3cb;
            --highlight: rgba(1, 215, 88, 0.2);
            --border-color: #194936;
            --panel-bg: #0c1016;
            --danger-color: #ff5252;
            --warning-color: #ffb224;
            --success-color: #01d758;
            --info-color: #00a3cb;
            --header-height: 40px;
        }

        body {
            margin: 0;
            padding: 0;
            font-family: 'Share Tech Mono', monospace;
            background-color: var(--terminal-bg);
            color: var(--terminal-text);
            overflow: hidden;
            line-height: 1.4;
        }
        
        .vds-container {
            display: flex;
            flex-direction: column;
            height: 100vh;
            background-color: var(--terminal-bg);
            color: var(--terminal-text);
            font-family: 'Share Tech Mono', monospace;
        }
        
        .vds-header {
            padding: 0 15px;
            height: var(--header-height);
            background-color: var(--panel-bg);
            border-bottom: 1px solid var(--border-color);
            display: flex;
            justify-content: space-between;
            align-items: center;
            color: var(--accent-color);
            font-weight: bold;
        }
        
        .vds-system-info {
            display: flex;
            gap: 15px;
        }
        
        .vds-metric {
            display: flex;
            align-items: center;
            gap: 5px;
            font-size: 12px;
        }
        
        .metric-label {
            color: var(--secondary-color);
        }
        
        .metric-bar {
            width: 40px;
            height: 8px;
            background-color: var(--terminal-bg);
            border-radius: 4px;
            overflow: hidden;
        }
        
        .metric-fill {
            height: 100%;
            width: 0%;
            transition: width 0.5s ease-in-out;
        }
        
        .cpu-fill {
            background-color: var(--warning-color);
        }
        
        .ram-fill {
            background-color: var(--secondary-color);
        }
        
        .disk-fill {
            background-color: var(--accent-color);
        }
        
        .metric-value {
            width: 30px;
            text-align: right;
        }
        
        .vds-body {
            display: flex;
            flex: 1;
            overflow: hidden;
        }
        
        .vds-main {
            flex: 1;
            display: flex;
            flex-direction: column;
            padding: 0;
            overflow: hidden;
            border-right: 1px solid var(--border-color);
        }
        
        .vds-terminal {
            flex: 1;
            background-color: var(--terminal-bg);
            padding: 10px 15px;
            overflow-y: auto;
            margin-bottom: 0;
            scrollbar-width: thin;
            scrollbar-color: var(--border-color) var(--terminal-bg);
        }
        
        .vds-terminal-content {
            height: 100%;
            overflow-y: auto;
        }
        
        .vds-file-system {
            height: 200px;
            background-color: var(--panel-bg);
            border-top: 1px solid var(--border-color);
            padding: 10px 15px;
            overflow-y: auto;
            user-select: none;
        }

        .vds-file-system-header {
            color: var(--secondary-color);
            font-weight: bold;
            margin-bottom: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .vds-sidebar {
            width: 40%;
            background-color: var(--panel-bg);
            padding: 0;
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }

        .vds-file-viewer {
            flex: 1;
            padding: 15px;
            overflow-y: auto;
            border-bottom: 1px solid var(--border-color);
            font-family: monospace;
            white-space: pre-wrap;
            word-break: break-word;
            overflow-x: auto;
            position: relative;
        }

        .vds-file-viewer-header {
            position: sticky;
            top: 0;
            background-color: var(--panel-bg);
            padding: 5px 0;
            margin-bottom: 10px;
            color: var(--secondary-color);
            font-weight: bold;
            display: flex;
            justify-content: space-between;
            align-items: center;
            z-index: 10;
            border-bottom: 1px solid var(--border-color);
        }

        .vds-file-content {
            background-color: var(--terminal-bg);
            padding: 15px;
            border-radius: 4px;
            border: 1px solid var(--border-color);
            max-height: 100%;
        }

        .vds-file-viewer pre {
            margin: 0;
            font-size: 14px;
        }

        .sql-keyword {
            color: var(--secondary-color);
        }

        .sql-string {
            color: var(--success-color);
        }

        .sql-number {
            color: var(--warning-color);
        }
        
        .vds-network {
            width: 100%;
            height: 200px;
            background-color: var(--terminal-bg);
            border-bottom: 1px solid var(--border-color);
            margin-bottom: 0;
            position: relative;
            overflow: hidden;
            background-image: radial-gradient(circle at 30% 50%, rgba(0, 163, 203, 0.05) 0%, transparent 50%), 
                             radial-gradient(circle at 70% 50%, rgba(1, 215, 88, 0.05) 0%, transparent 50%);
            perspective: 500px;
        }
        
        .vds-status {
            padding: 15px;
            flex: 0 0 auto;
        }

        .vds-status h3 {
            color: var(--secondary-color);
            margin-top: 0;
            margin-bottom: 15px;
            font-size: 16px;
        }

        .vds-status-item {
            margin-bottom: 8px;
            line-height: 1.4;
        }

        .vds-status-item span {
            color: var(--accent-color);
        }
        
        .vds-command-input {
            display: flex;
            padding: 10px 15px;
            background-color: var(--terminal-bg);
            border-top: 1px solid var(--border-color);
        }
        
        .vds-prompt {
            color: var(--accent-color);
            margin-right: 8px;
            user-select: none;
        }
        
        #vds-command {
            flex: 1;
            background: transparent;
            border: none;
            color: var(--terminal-text);
            font-family: 'Share Tech Mono', monospace;
            outline: none;
            font-size: 14px;
        }
        
        .file {
            cursor: pointer;
            padding: 5px 8px;
            border-radius: 3px;
            margin: 2px 0;
            transition: background-color 0.2s;
        }
        
        .file:hover {
            background-color: var(--highlight);
        }
        
        .directory {
            color: var(--accent-color);
            font-weight: bold;
        }
        
        .trace-level {
            width: 100%;
            height: 20px;
            background-color: var(--terminal-bg);
            border: 1px solid var(--border-color);
            border-radius: 3px;
            margin-top: 5px;
            position: relative;
            overflow: hidden;
        }
        
        .trace-level-fill {
            height: 100%;
            background-color: var(--danger-color);
            width: 0%; 
            transition: width 0.5s ease;
        }
        
        .trace-level-warning {
            position: absolute;
            top: 0;
            bottom: 0;
            width: 2px;
            background-color: var(--warning-color);
            left: 70%; 
        }
        
        .timer {
            margin-top: 15px;
            padding: 10px;
            background-color: var(--terminal-bg);
            border: 1px solid var(--border-color);
            border-radius: 3px;
            display: none; 
        }

        .timer-heading {
            color: var(--warning-color);
            font-size: 14px;
            margin-bottom: 5px;
        }

        #timer-countdown {
            color: var(--danger-color);
            font-size: 18px;
            font-weight: bold;
        }
        
        .network-node {
            position: absolute;
            width: 60px;
            height: 60px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            color: var(--terminal-text);
            transform-style: preserve-3d;
            transition: transform 0.3s ease-in-out;
        }
        
        .network-node:hover {
            transform: translateY(-5px);
        }
        
        .network-node .icon {
            width: 40px;
            height: 40px;
            background-size: contain;
            background-repeat: no-repeat;
            background-position: center;
            margin-bottom: 5px;
            filter: drop-shadow(0 0 5px currentColor);
            position: relative;
        }
        
        .network-node .label {
            font-size: 11px;
            font-weight: bold;
            text-shadow: 0 0 5px currentColor;
        }
        
        .network-node .ip {
            font-size: 9px;
            opacity: 0.8;
        }
        
        .network-node.you {
            color: var(--secondary-color);
        }
        
        .network-node.you .icon {
            background-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="%2300a3cb"><path d="M4 2h16a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2zm0 2v12h16V4H4zm8 3a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm-5 5a1 1 0 1 1 0-2 1 1 0 0 1 0 2zm10 0a1 1 0 1 1 0-2 1 1 0 0 1 0 2zm-5 3a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"/></svg>');
        }
        
        .network-node.current {
            color: var(--accent-color);
        }
        
        .network-node.current .icon {
            background-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="%2301d758"><path d="M5 2h14a2 2 0 0 1 2 2v16a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2zm0 2v16h14V4H5zm2 3h10v2H7V7zm0 4h5v2H7v-2zm0 4h8v2H7v-2z"/></svg>');
        }
        
        .network-node .icon::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 100%;
            border-radius: 50%;
            background-color: currentColor;
            opacity: 0.1;
            top: 0;
            left: 0;
            z-index: -1;
            animation: pulse-ring 3s infinite;
            transform-origin: center;
        }
        
        @keyframes pulse-ring {
            0% {
                transform: scale(1);
                opacity: 0.1;
            }
            50% {
                transform: scale(1.8);
                opacity: 0;
            }
            100% {
                transform: scale(1);
                opacity: 0;
            }
        }
        
        .network-line {
            position: absolute;
            height: 2px;
            transform-origin: 0 0;
            background: linear-gradient(90deg, 
                var(--secondary-color) 0%, 
                var(--accent-color) 100%);
            box-shadow: 0 0 8px var(--secondary-color);
            overflow: hidden;
            opacity: 0.8;
            z-index: -1;
        }
        
        .network-connection {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: -1;
            opacity: 0.1;
        }
        
        .data-packet {
            position: absolute;
            width: 6px;
            height: 6px;
            border-radius: 50%;
            top: -2px;
            filter: blur(1px);
            animation: data-transfer 1.5s infinite cubic-bezier(0.45, 0.05, 0.55, 0.95);
        }
        
        .data-packet-upload {
            background-color: var(--secondary-color);
            box-shadow: 0 0 5px var(--secondary-color), 0 0 10px var(--secondary-color);
        }
        
        .data-packet-download {
            background-color: var(--accent-color);
            box-shadow: 0 0 5px var(--accent-color), 0 0 10px var(--accent-color);
        }
        
        @keyframes data-transfer {
            0% {
                left: 0%;
                opacity: 0;
                transform: scale(0.8);
            }
            10% {
                opacity: 1;
                transform: scale(1);
            }
            90% {
                opacity: 1;
                transform: scale(1);
            }
            100% {
                left: 100%;
                opacity: 0;
                transform: scale(0.8);
            }
        }
        
        .firewall-indicator {
            position: absolute;
            width: 10px;
            height: 100%;
            top: -4px;
            background: repeating-linear-gradient(
                45deg,
                transparent,
                transparent 2px,
                var(--danger-color) 2px,
                var(--danger-color) 4px
            );
            opacity: 0.3;
            z-index: 2;
        }
        
        .port-scan {
            position: absolute;
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: conic-gradient(
                transparent 0deg,
                var(--success-color) 90deg,
                transparent 90deg
            );
            animation: port-scan-rotate 3s linear infinite;
            opacity: 0;
            filter: blur(5px);
        }
        
        @keyframes port-scan-rotate {
            0% {
                transform: rotate(0deg);
                opacity: 0.3;
            }
            50% {
                opacity: 0.5;
            }
            100% {
                transform: rotate(360deg);
                opacity: 0.3;
            }
        }
        
        .activity-indicator {
            position: absolute;
            bottom: 10px;
            left: 10px;
            display: flex;
            gap: 5px;
            align-items: center;
            font-size: 10px;
            color: var(--secondary-color);
        }
        
        .activity-blip {
            width: 3px;
            height: 5px;
            background-color: var(--secondary-color);
            animation: activity-blip 0.7s ease-in-out infinite;
            opacity: 0.5;
        }
        
        .activity-blip:nth-child(2) {
            animation-delay: 0.1s;
            height: 7px;
        }
        
        .activity-blip:nth-child(3) {
            animation-delay: 0.2s;
            height: 10px;
        }
        
        .activity-blip:nth-child(4) {
            animation-delay: 0.3s;
            height: 6px;
        }
        
        .activity-blip:nth-child(5) {
            animation-delay: 0.4s;
            height: 8px;
        }
        
        .activity-blip:nth-child(6) {
            animation-delay: 0.5s;
            height: 10px;
        }
        
        @keyframes activity-blip {
            0%, 100% {
                opacity: 0.3;
                transform: scaleY(0.8);
            }
            50% {
                opacity: 1;
                transform: scaleY(1.2);
            }
        }
        
        .command-response {
            margin: 5px 0;
            white-space: pre-wrap;
            word-break: break-all;
        }
        
        .command-entry {
            margin: 5px 0;
            padding: 2px 0;
        }

        .command-entry:hover {
            background-color: rgba(255, 255, 255, 0.05);
        }
        
        .command {
            color: var(--secondary-color);
        }
        
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.8);
            animation: fadein 0.3s;
        }

        @keyframes fadein {
            from { opacity: 0; }
            to   { opacity: 1; }
        }
        
        .modal-content {
            background-color: var(--panel-bg);
            margin: 10% auto;
            padding: 20px;
            border: 1px solid var(--border-color);
            border-radius: 5px;
            width: 70%;
            max-width: 700px;
            box-shadow: 0 0 20px rgba(1, 215, 88, 0.2);
            animation: slidein 0.3s;
        }

        @keyframes slidein {
            from { transform: translateY(-20px); opacity: 0; }
            to   { transform: translateY(0); opacity: 1; }
        }
        
        .close-button {
            color: var(--secondary-color);
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
            transition: color 0.2s;
        }

        .close-button:hover {
            color: var(--accent-color);
        }
        
        .scan-result, .decrypt-result, .injection-result, .proxy-result {
            margin-top: 10px;
            padding: 15px;
            background-color: var(--terminal-bg);
            border: 1px solid var(--border-color);
            border-radius: 4px;
            max-height: 300px;
            overflow-y: auto;
            font-family: monospace;
        }
        
        .loading-animation {
            display: flex;
            justify-content: center;
            margin: 20px 0;
        }
        
        .loading-dot {
            width: 10px;
            height: 10px;
            margin: 0 5px;
            background-color: var(--secondary-color);
            border-radius: 50%;
            animation: pulse 1.5s infinite;
        }
        
        .loading-dot:nth-child(2) {
            animation-delay: 0.2s;
        }
        
        .loading-dot:nth-child(3) {
            animation-delay: 0.4s;
        }
        
        @keyframes pulse {
            0% {
                transform: scale(0.8);
                opacity: 0.3;
            }
            50% {
                transform: scale(1.2);
                opacity: 1;
            }
            100% {
                transform: scale(0.8);
                opacity: 0.3;
            }
        }
        
        .danger {
            color: var(--danger-color);
        }
        
        .success {
            color: var(--success-color);
        }
        
        .warning {
            color: var(--warning-color);
        }
        
        .info {
            color: var(--secondary-color);
        }

        button {
            background-color: var(--terminal-bg);
            color: var(--accent-color);
            border: 1px solid var(--accent-color);
            border-radius: 3px;
            padding: 6px 12px;
            font-family: 'Share Tech Mono', monospace;
            font-size: 14px;
            cursor: pointer;
            transition: all 0.2s;
        }

        button:hover {
            background-color: var(--accent-color);
            color: var(--terminal-bg);
        }

        .danger-button {
            color: var(--danger-color);
            border-color: var(--danger-color);
        }

        .danger-button:hover {
            background-color: var(--danger-color);
            color: var(--terminal-bg);
        }

        #disconnect-button {
            background-color: transparent;
            color: var(--danger-color);
            border: 1px solid var(--danger-color);
        }

        #disconnect-button:hover {
            background-color: var(--danger-color);
            color: var(--terminal-bg);
        }
        
        .file-system-info {
            color: var(--secondary-color);
            text-align: center;
            padding: 20px;
            font-size: 14px;
            opacity: 0.8;
        }

        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }

        ::-webkit-scrollbar-track {
            background: var(--terminal-bg);
        }

        ::-webkit-scrollbar-thumb {
            background: var(--border-color);
            border-radius: 4px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: var(--secondary-color);
        }

        .panel-buttons {
            display: flex;
            gap: 10px;
        }

        .panel-button {
            background: none;
            border: none;
            color: var(--secondary-color);
            cursor: pointer;
            font-size: 18px;
            padding: 0;
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 3px;
        }

        .panel-button:hover {
            background-color: var(--highlight);
            color: var(--accent-color);
        }

        .file-close {
            cursor: pointer;
            color: var(--border-color);
            font-size: 18px;
            padding: 0 5px;
        }

        .file-close:hover {
            color: var(--danger-color);
        }

        .file-permissions {
            color: var(--border-color);
            font-size: 12px;
            margin-left: 5px;
        }

        .mission-status-indicator {
            position: absolute;
            width: 16px;
            height: 16px;
            border-radius: 50%;
            border: 2px solid rgba(255, 255, 255, 0.3);
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(0, 0, 0, 0.5);
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);
            top: 10px;
            right: 10px;
            z-index: 100;
        }

        .mission-status-light {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: #ff4444;
            box-shadow: 0 0 6px #ff4444, 0 0 12px #ff4444;
            animation: pulse-red 1.5s ease-in-out infinite;
        }

        .mission-status-light.completed {
            background: #00ff00;
            box-shadow: 0 0 6px #00ff00, 0 0 12px #00ff00;
            animation: pulse-green 1.5s ease-in-out infinite;
        }

        @keyframes pulse-red {
            0%, 100% {
                opacity: 1;
                transform: scale(1);
            }
            50% {
                opacity: 0.3;
                transform: scale(0.8);
            }
        }

        @keyframes pulse-green {
            0%, 100% {
                opacity: 1;
                transform: scale(1);
            }
            50% {
                opacity: 0.5;
                transform: scale(0.9);
            }
        }

        .boot-animation-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: var(--terminal-bg);
            z-index: 9999;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            opacity: 1;
            transition: opacity 0.4s ease-out;
        }

        .boot-content {
            width: 80%;
            max-width: 600px;
        }

        .boot-logo {
            font-size: 80px;
            font-weight: bold;
            color: var(--accent-color);
            text-align: center;
            margin-bottom: 30px;
            font-family: 'Share Tech Mono', monospace;
            text-shadow: 0 0 10px var(--accent-color), 0 0 20px var(--accent-color);
            animation: pulse-logo 2s infinite alternate;
        }

        @keyframes pulse-logo {
            0% {
                opacity: 0.7;
                text-shadow: 0 0 5px var(--accent-color);
            }
            100% {
                opacity: 1;
                text-shadow: 0 0 15px var(--accent-color), 0 0 30px var(--accent-color);
            }
        }

        .boot-messages {
            font-family: 'Share Tech Mono', monospace;
            color: var(--terminal-text);
            margin-bottom: 30px;
        }

        .boot-message {
            margin: 10px 0;
            position: relative;
            padding-left: 20px;
            opacity: 0;
            transform: translateY(10px);
            animation: fade-in-message 0.3s forwards;
            animation-delay: calc(var(--index) * 0.5s);
        }

        .boot-message::before {
            content: ">";
            position: absolute;
            left: 0;
            color: var(--secondary-color);
        }

        .boot-message.success {
            color: var(--success-color);
            font-weight: bold;
        }

        @keyframes fade-in-message {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .boot-progress {
            width: 100%;
            height: 4px;
            background-color: var(--panel-bg);
            border-radius: 2px;
            overflow: hidden;
        }

        .boot-progress-bar {
            height: 100%;
            width: 0%;
            background-color: var(--accent-color);
            border-radius: 2px;
            animation: progress 3.5s ease-in-out forwards;
            box-shadow: 0 0 10px var(--accent-color);
        }

        @keyframes progress {
            0% {
                width: 0%;
            }
            80% {
                width: 90%;
            }
            100% {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div id="boot-animation-overlay" class="boot-animation-overlay">
        <div class="boot-content">
            <div class="boot-logo">VDS</div>
            <div class="boot-messages" id="boot-messages">
                <div class="boot-message"><?php echo $languageController->translate('vds.boot_initializing_system'); ?></div>
                <div class="boot-message"><?php echo $languageController->translate('vds.boot_loading_kernel'); ?></div>
                <div class="boot-message"><?php echo $languageController->translate('vds.boot_establishing_connection'); ?></div>
                <div class="boot-message"><?php echo $languageController->translate('vds.boot_mounting_filesystems'); ?></div>
                <div class="boot-message"><?php echo $languageController->translate('vds.boot_starting_services'); ?></div>
                <div class="boot-message"><?php echo $languageController->translate('vds.boot_authenticating'); ?></div>
                <div class="boot-message success"><?php echo $languageController->translate('vds.boot_connection_established', ['ip' => $currentIp]); ?></div>
            </div>
            <div class="boot-progress">
                <div class="boot-progress-bar"></div>
            </div>
        </div>
    </div>
    <div class="vds-container">
        <div class="vds-header">
            <div class="vds-title"><?php echo $languageController->translate('vds.vds_terminal_connected_to', ['ip' => $currentIp]); ?></div>
            <div class="vds-system-info">
                <div class="vds-metric">
                    <span class="metric-label"><?php echo $languageController->translate('vds.vds_metric_cpu'); ?></span>
                    <div class="metric-bar">
                        <div class="metric-fill cpu-fill"></div>
                    </div>
                    <span class="metric-value cpu-value">0%</span>
                </div>
                <div class="vds-metric">
                    <span class="metric-label"><?php echo $languageController->translate('vds.vds_metric_ram'); ?></span>
                    <div class="metric-bar">
                        <div class="metric-fill ram-fill"></div>
                    </div>
                    <span class="metric-value ram-value">0%</span>
                </div>
                <div class="vds-metric">
                    <span class="metric-label"><?php echo $languageController->translate('vds.vds_metric_disk'); ?></span>
                    <div class="metric-bar">
                        <div class="metric-fill disk-fill"></div>
                    </div>
                    <span class="metric-value disk-value">0%</span>
                </div>
            </div>
            <div class="vds-controls">
                <button id="disconnect-button" style="margin-left: auto;"><?php echo $languageController->translate('vds.vds_disconnect_button'); ?></button>
            </div>
        </div>

        <div class="vds-body">
            <div class="vds-main">
                <div class="vds-terminal">
                    <div class="vds-terminal-content" id="terminal-content">
                        <div class="command-response"><?php echo $languageController->translate('vds.vds_connected_to', ['ip' => $currentIp]); ?></div>
                        <div class="command-response"><?php echo $languageController->translate('vds.vds_help_hint'); ?></div>
                    </div>
                </div>

                <div class="vds-file-system">
                    <div class="vds-file-system-header">
                        <span><?php echo $languageController->translate('vds.vds_current_directory'); ?> <span id="current-directory"><?php echo $currentDirectory; ?></span></span>
                        <div class="panel-buttons">
                            <button class="panel-button" id="refresh-directory" title="<?php echo $languageController->translate('vds.vds_refresh_directory'); ?>">↻</button>
                        </div>
                    </div>
                    <div class="file-system-content" id="file-system-content">
                        <div class="file-system-info"><?php echo $languageController->translate('vds.vds_use_ls_command'); ?></div>
                    </div>
                </div>

                <div class="vds-command-input">
                    <span class="vds-prompt">root@<?php echo explode('.', $currentIp)[0]; ?>:~$</span>
                    <input type="text" id="vds-command" autofocus>
                </div>
            </div>

            <div class="vds-sidebar">
                <div class="vds-file-viewer" id="file-viewer">
                    <div class="vds-file-viewer-header">
                        <span id="file-viewer-title"><?php echo $languageController->translate('vds.vds_file_viewer'); ?></span>
                        <span class="file-close" id="close-file-viewer">×</span>
                    </div>
                    <div class="vds-file-content" id="file-viewer-content">
                        <div style="text-align: center; color: var(--secondary-color);">
                            <?php echo $languageController->translate('vds.vds_no_file_selected'); ?><br>
                            <?php echo $languageController->translate('vds.vds_use_cat_command', ['command' => '<span style="color: var(--accent-color)">cat [filename]</span>']); ?>
                        </div>
                    </div>
                </div>

                <div class="vds-network" id="network-map">
                </div>

                <div class="vds-status">
                    <div class="vpn-status-container" id="vpn-status-container" style="display: none; margin-bottom: 15px;">
                        <div class="vpn-status-bar">
                            <span class="vpn-icon">🔒</span>
                            <span id="vpn-status-text">VPN</span>
                            <span id="vpn-capacity-text"></span>
                            <button id="vpn-toggle-btn" class="vpn-toggle-btn"><?php echo $languageController->translate('game.marketplace.vpn.activate'); ?></button>
                        </div>
                    </div>
                    <h3><?php echo $languageController->translate('vds.vds_mission_status'); ?></h3>
                    <div class="vds-status-item"><?php echo $languageController->translate('vds.vds_connected_to_label'); ?> <span id="connected-ip"><?php echo $currentIp; ?></span></div>
                    <div class="vds-status-item"><?php echo $languageController->translate('vds.vds_mission_label'); ?> <span><?php echo $activeMission ? $activeMission->getTitle() : 'Demo Mode'; ?></span></div>
                    <div class="vds-status-item">
                        <?php echo $languageController->translate('vds.vds_trace_level'); ?> <span id="trace-level"><?php echo $traceLevel; ?>%</span>
                        <div class="trace-level">
                            <div class="trace-level-fill" id="trace-level-fill" style="width: <?php echo $traceLevel; ?>%;"></div>
                            <div class="trace-level-warning"></div>
                        </div>
                    </div>
                    <div class="timer" id="timer">
                        <div class="timer-heading"><?php echo $languageController->translate('vds.vds_time_remaining'); ?></div>
                        <div id="timer-countdown"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="scan-modal" class="modal">
        <div class="modal-content">
            <span class="close-button" id="scan-modal-close">&times;</span>
            <h2><?php echo $languageController->translate('vds.vds_port_scan_results'); ?></h2>
            <div class="loading-animation" id="scan-loading">
                <div class="loading-dot"></div>
                <div class="loading-dot"></div>
                <div class="loading-dot"></div>
            </div>
            <div class="scan-result" id="scan-result" style="display: none;"></div>
        </div>
    </div>

    <div id="decrypt-modal" class="modal">
        <div class="modal-content">
            <span class="close-button" id="decrypt-modal-close">&times;</span>
            <h2><?php echo $languageController->translate('vds.vds_decryption_process'); ?></h2>
            <div class="loading-animation" id="decrypt-loading">
                <div class="loading-dot"></div>
                <div class="loading-dot"></div>
                <div class="loading-dot"></div>
            </div>
            <div class="decrypt-result" id="decrypt-result" style="display: none;"></div>
        </div>
    </div>

    <script src="<?php echo PUBLIC_URL; ?>/js/vds.js"></script>
    <script>
        window.BASE_URL = '<?php echo BASE_URL; ?>';
        window.ASSETS_URL = '<?php echo ASSETS_URL; ?>';
        window.PUBLIC_URL = '<?php echo PUBLIC_URL; ?>';
        window.API_URL = '<?php echo API_URL; ?>';
        window.LANGUAGES_URL = '<?php echo LANGUAGES_URL; ?>';

        document.addEventListener('DOMContentLoaded', function() {
            if (typeof LanguageManager === 'function') {
                window.langManager = new LanguageManager();
                console.log('Language manager initialized');
            } else {
                console.error('LanguageManager class not found');
            }

            const bootMessages = document.querySelectorAll('.boot-message');
            bootMessages.forEach((message, index) => {
                message.style.setProperty('--index', index);
            });

            setTimeout(function() {
                const bootOverlay = document.getElementById('boot-animation-overlay');
                bootOverlay.style.opacity = '0';
                setTimeout(function() {
                    bootOverlay.style.display = 'none';
                }, 400);
            }, 4000);
        });

        const missionId = <?php echo $missionId ? $missionId : 'null'; ?>;
        let currentIp = '<?php echo $currentIp; ?>';
        let currentDirectory = '<?php echo $currentDirectory; ?>';
        let traceLevel = <?php echo $traceLevel; ?>;
        window.timerStarted = <?php echo $timerStarted ? 'true' : 'false'; ?>;
        const traceThreshold = <?php echo $activeMission ? $activeMission->getTraceThreshold() : 100; ?>;
        const traceTimer = <?php echo $activeMission ? $activeMission->getTraceTimer() : 300; ?>;

        window.timerEndTime = null;
        if (window.timerStarted && <?php echo $activeMission ? 'true' : 'false'; ?>) {
            <?php if ($activeMission && !empty($progress['timer_started_at'])): ?>
            const timerStartedAt = new Date('<?php echo $progress['timer_started_at']; ?>').getTime();
            const currentTime = new Date().getTime();
            const elapsedMs = currentTime - timerStartedAt;
            const remainingMs = (traceTimer * 1000) - elapsedMs;

            if (remainingMs > 0) {
                window.timerEndTime = new Date(currentTime + remainingMs);
                document.addEventListener('DOMContentLoaded', function() {
                    document.getElementById('timer').style.display = 'block';
                    startCountdown(window.timerEndTime);
                });
            }
            <?php endif; ?>
        }
    </script>
</body>
</html>
